(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36762,       1136]
NotebookOptionsPosition[     33387,       1027]
NotebookOutlinePosition[     33962,       1047]
CellTagsIndexPosition[     33919,       1044]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Baker-Schmidt camera with conic primary", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["BakerSchmidtCameraCP",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 TagBox[
  PanelBox[
   TagBox[GridBox[{
      {
       StyleBox["\<\"Input variables\"\>", "Georgia",
        StripOnInput->False,
        FontSize->18,
        FontWeight->Bold]},
      {
       TagBox[GridBox[{
          {Cell["f1",
            FontWeight->Bold], Cell["focal length of the primary mirror"]},
          {Cell["\[Gamma]",
            FontWeight->Bold], Cell[
           "where \[Dash] \[Gamma]\[CenterDot]f1 is the radius of secondary \
mirror"]},
          {Cell["\[Beta]",
            FontWeight->Bold], Cell["\<\
where \[Beta] = 1 \[Dash] \[Alpha] and \[Alpha] is the obstruction factor \
(under condition \[Alpha] \[GreaterEqual] 0.40)\
\>"]},
          {Cell["diam",
            FontWeight->Bold], Cell["diameter of the primary mirror"]},
          {Cell["\[Theta]",
            FontWeight->Bold], Cell["field angle in degrees"]}
         },
         AutoDelete->False,
         BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
         FrameStyle->RGBColor[1, 0.5, 0],
         GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
         GridBoxDividers->{
          "Columns" -> {False, {True}, False}, 
           "Rows" -> {False, {True}, False}},
         GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
        "TextGrid"]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Center}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
    "Column"],
   Background->GrayLevel[0.85]],
  Deploy,
  DefaultBaseStyle->"Deploy"]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["BakerSchmidtCameraCPInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A third-order analysis of the Baker-Schmidt camera with conic secondary\
\>", "Title"],

Cell["\<\
Using TotalAberration auxiliary function you may calculate symbolic and/or \
numerical intermediate variable, so to explore the Baker-Schmidt camera \
project\[CloseCurlyQuote]s parameter. Here is an example of a third-order \
analysis.\
\>", "Text"],

Cell["\<\
We start with an optical system formed by two mirrors, of which the secondary \
mirror is conic. (the variables f1, \[Beta], \[Gamma], K2, x, \[Theta], \
\[Lambda]1, \[Lambda]2, \[Lambda]3 have to be unassigned, for that we use \
Clear)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f1", ",", " ", "\[Beta]", ",", " ", "\[Gamma]", ",", " ", "K2", ",", " ", 
    "x", ",", " ", "\[Theta]", ",", " ", "\[Lambda]1", ",", " ", "\[Lambda]2",
     ",", " ", "\[Lambda]3"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "f1"}], ",", 
      RowBox[{
       RowBox[{"-", "\[Gamma]"}], " ", "f1"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"for", " ", "BK7", " ", "it", " ", "is", " ", "ind"}], " ", "=", 
    " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "1.518722", ",", " ", "1", ",", " ", 
        RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "1.522829", ",", " ", "1", ",", " ", 
        RowBox[{"-", "1"}], ",", " ", "1"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "1.514719", ",", " ", "1", ",", " ", 
        RowBox[{"-", "1"}], ",", " ", "1"}], "}"}]}], "}"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "K2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f1"}], ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  "]"}]}], "Input"],

Cell["The focal length and the back focal are", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq1", " ", "=", " ", 
  RowBox[{"First", "@", 
   RowBox[{"Simplify", "[", 
    StyleBox["GOfocalLength",
     FontWeight->"Bold"], "]"}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f1", " ", "\[Gamma]"}], 
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq2", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Together", "[", 
    RowBox[{
     StyleBox[
      RowBox[{"GOdistancegauss", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "GOn"}], "]"}], "]"}],
      FontWeight->"Bold"], " ", "-", " ", 
     RowBox[{"\[Beta]", " ", "f1"}]}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["\[Beta]", "2"]}], "-", 
     RowBox[{"2", " ", "\[Beta]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Gamma]"}], ")"}]}], "+", "\[Gamma]"}], 
    ")"}]}], 
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}]]], "Output"]
}, Open  ]],

Cell["\<\
for \[Beta] = 0.6 (obstruction factor, \[Alpha] = 1 \[Dash] \[Beta] = 0.4), \
we have that\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ft", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"eq1", " ", "/.", " ", 
    RowBox[{"\[Beta]", " ", "->", " ", "0.6"}]}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"total", " ", "focal"}], " ", "*)"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f1", " ", "\[Gamma]"}], 
  RowBox[{
   RowBox[{"-", "0.8`"}], "+", "\[Gamma]"}]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bf", " ", "=", " ", 
  RowBox[{"Simplify", "[", 
   RowBox[{"eq2", " ", "/.", " ", 
    RowBox[{"\[Beta]", " ", "->", " ", "0.6"}]}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"back", " ", "focal"}], "*)"}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"f1", " ", 
   RowBox[{"(", 
    RowBox[{"0.48`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.19999999999999996`", " ", "\[Gamma]"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "0.8`"}], "+", "\[Gamma]"}]]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The focal plane is behind the primary mirror if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"0.48", "-", 
      RowBox[{"0.2", "\[Gamma]"}]}], 
     RowBox[{
      RowBox[{"-", "0.8"}], "+", "\[Gamma]"}]], ">", "0"}], TraditionalForm]]],
 " for instance, when 1 < \[Gamma] < 2.4. "
}], "Text"],

Cell["Condition to have a flat field", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq3", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", "GOSeidelCurvature", "]"}], "]"}], "//", 
   "Factor"}]}]], "Input",
 CellChangeTimes->{{3.6761891099588337`*^9, 3.676189110484864*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[Beta]"}], "-", "\[Gamma]", "-", 
    RowBox[{"2", " ", "\[Delta]"}], "+", 
    RowBox[{"2", " ", "\[Beta]", " ", "\[Delta]"}], "+", 
    RowBox[{"\[Gamma]", " ", "\[Delta]"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq3", "\[Equal]", "0"}], ",", "\[Delta]"}], "]"}], "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Delta]", "\[Rule]", 
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}], 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceAll", "[", 
  RowBox[{"sol3", ",", 
   RowBox[{"\[Beta]", "\[Rule]", "0.6"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Delta]", "\[Rule]", 
   FractionBox[
    RowBox[{"1.2`", "\[VeryThinSpace]", "+", "\[Gamma]"}], 
    RowBox[{
     RowBox[{"-", "0.8`"}], "+", "\[Gamma]"}]]}], "}"}]], "Output"]
}, Open  ]],

Cell["The corresponding aberration coefficients are", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"eq4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"(", 
    RowBox[{"GOSphericalCoefficient", "/.", "sol3"}], ")"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"eq5", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"(", 
    RowBox[{"GOComaCoefficient", "/.", "sol3"}], ")"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"eq6", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"(", 
    RowBox[{"GOAstigmatismCoefficient", "/.", "sol3"}], ")"}], 
   "]"}]}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", "+", 
   RowBox[{"8", " ", "K2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], "4"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Beta]", "4"]}], "+", 
   RowBox[{"16", " ", 
    SuperscriptBox["\[Beta]", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}]}], "-", 
   RowBox[{"16", " ", "\[Gamma]"}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Gamma]", "2"]}], "-", 
   SuperscriptBox["\[Gamma]", "3"], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Beta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"6", "-", 
      RowBox[{"6", " ", "\[Gamma]"}], "+", 
      SuperscriptBox["\[Gamma]", "2"]}], ")"}]}], "-", 
   RowBox[{"16", " ", "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"3", " ", "\[Gamma]"}], "+", 
      SuperscriptBox["\[Gamma]", "2"]}], ")"}]}]}], 
  RowBox[{"32", " ", 
   SuperscriptBox["f1", "3"], " ", 
   SuperscriptBox["\[Gamma]", "3"]}]]], "Output"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "8"}], "-", 
   RowBox[{"8", " ", "K2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], "3"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Beta]", "3"]}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Beta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "\[Gamma]"}], ")"}]}], "+", 
   RowBox[{"8", " ", "\[Gamma]"}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["\[Gamma]", "2"]}], "+", 
   SuperscriptBox["\[Gamma]", "3"], "+", 
   RowBox[{"2", " ", "\[Beta]", " ", 
    RowBox[{"(", 
     RowBox[{"12", "-", 
      RowBox[{"8", " ", "\[Gamma]"}], "+", 
      SuperscriptBox["\[Gamma]", "2"]}], ")"}]}]}], 
  RowBox[{"8", " ", 
   SuperscriptBox["f1", "2"], " ", 
   SuperscriptBox["\[Gamma]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}], ")"}]}]]], "Output"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"8", " ", "K2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], "2"]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["\[Beta]", "2"]}], "+", 
      RowBox[{"4", " ", "\[Beta]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}]}], "-", 
      RowBox[{"6", " ", "\[Gamma]"}], "+", 
      SuperscriptBox["\[Gamma]", "2"]}], ")"}]}]}], 
  RowBox[{"8", " ", "f1", " ", "\[Gamma]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"2", " ", "\[Beta]"}], "+", "\[Gamma]"}], ")"}], 
    "2"]}]]], "Output"]
}, Open  ]],

Cell["\<\
That is, astigmatism vanishes together with the field curvature. We can find \
the value of the aspheric constant of the corrector, as well as of the conic \
constant of the secondary mirror, by eliminating the spherical aberration and \
coma\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol4", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"a4", 
          RowBox[{"(", 
           RowBox[{"GON", "-", "1"}], ")"}]}], "+", "eq4"}], "\[Equal]", 
        "0"}], ",", 
       RowBox[{"eq5", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "K2"}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a4", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"16", " ", 
         SuperscriptBox["\[Beta]", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Gamma]"}], ")"}], "3"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[Beta]", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "8"}], "+", 
           RowBox[{"3", " ", "\[Gamma]"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[Beta]", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"48", "-", 
           RowBox[{"36", " ", "\[Gamma]"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], "+", 
        RowBox[{"\[Beta]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "64"}], "+", 
           RowBox[{"72", " ", "\[Gamma]"}], "-", 
           RowBox[{"22", " ", 
            SuperscriptBox["\[Gamma]", "2"]}], "+", 
           SuperscriptBox["\[Gamma]", "3"]}], ")"}]}]}], 
       RowBox[{"32", " ", 
        SuperscriptBox["f1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "GON"}], ")"}], " ", 
        SuperscriptBox["\[Gamma]", "3"]}]]}]}], ",", 
    RowBox[{"K2", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "8"}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[Beta]", "3"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[Beta]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", "\[Gamma]"}], ")"}]}], "+", 
       RowBox[{"8", " ", "\[Gamma]"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["\[Gamma]", "2"]}], "+", 
       SuperscriptBox["\[Gamma]", "3"], "+", 
       RowBox[{"2", " ", "\[Beta]", " ", 
        RowBox[{"(", 
         RowBox[{"12", "-", 
          RowBox[{"8", " ", "\[Gamma]"}], "+", 
          SuperscriptBox["\[Gamma]", "2"]}], ")"}]}]}], 
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Beta]"}], ")"}], "3"]}]]}]}], "}"}], 
  "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Baker-Schmidt camera with conic secondary - examples", "Title"],

Cell["\<\
To use the BakerSchmidtCameraCP function you can either use directly the \
function BakerSchmidtCameraCP[f1, \[Gamma], \[Beta], diam, \[Theta]] or use \
the interactive panel created by calling the function \
BakerSchmidtCameraCPInputPanel[].
It let\[CloseCurlyQuote]s you to set input values and then call the \
BakerSchmidtCameraCP function. Moreover, it helps to load examples from the \
saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Baker-Schmidt camera with a primary F/2", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", "2.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraCP", "[", 
   RowBox[{
   "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraCP", "[", 
   RowBox[{
   "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", 
    " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraCP", "[", 
   RowBox[{
   "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", 
    " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraCP", "[", 
   RowBox[{
   "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", 
    " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraCP", "[", 
   RowBox[{
   "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", 
    " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Baker-Schmidt camera with a primary F/2.5", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraCP", "[", 
  RowBox[{
  "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell["Baker-Schmidt camera with a primary F/2.11", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "422.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", "1.91"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.2"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraCP", "[", 
  RowBox[{
  "f1", ",", "\[Gamma]", ",", "\[Beta]", ",", "diam", ",", "\[Theta]"}], 
  "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<BakerSchmidtCameraCP\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraCP", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraCPInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
Visible->True,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 56, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[648, 26, 35, 0, 43, "Subsection"],
Cell[686, 28, 115, 2, 46, "Text"],
Cell[804, 32, 1723, 46, 263, "Text"],
Cell[2530, 80, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4677, 138, 40, 0, 43, "Subsection"],
Cell[4720, 140, 256, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5013, 151, 40, 0, 43, "Subsection"],
Cell[5056, 153, 111, 2, 46, "Text"],
Cell[5170, 157, 3193, 83, 551, "Text"],
Cell[8366, 242, 2296, 56, 473, "Text"],
Cell[10665, 300, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14179, 395, 96, 2, 71, "Title"],
Cell[14278, 399, 260, 5, 46, "Text"],
Cell[14541, 406, 260, 5, 46, "Text"],
Cell[14804, 413, 2175, 63, 165, "Input"],
Cell[16982, 478, 55, 0, 46, "Text"],
Cell[CellGroupData[{
Cell[17062, 482, 176, 5, 32, "Input"],
Cell[17241, 489, 168, 5, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17446, 499, 347, 10, 32, "Input"],
Cell[17796, 511, 442, 15, 53, "Output"]
}, Open  ]],
Cell[18253, 529, 114, 3, 46, "Text"],
Cell[CellGroupData[{
Cell[18392, 536, 253, 6, 32, "Input"],
Cell[18648, 544, 131, 4, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18816, 553, 247, 6, 32, "Input"],
Cell[19066, 561, 249, 7, 49, "Output"]
}, Open  ]],
Cell[19330, 571, 338, 11, 59, "Text"],
Cell[19671, 584, 46, 0, 46, "Text"],
Cell[CellGroupData[{
Cell[19742, 588, 242, 6, 32, "Input"],
Cell[19987, 596, 400, 12, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20424, 613, 186, 6, 32, "Input"],
Cell[20613, 621, 267, 8, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20917, 634, 127, 3, 32, "Input"],
Cell[21047, 639, 219, 6, 48, "Output"]
}, Open  ]],
Cell[21281, 648, 61, 0, 46, "Text"],
Cell[CellGroupData[{
Cell[21367, 652, 516, 15, 99, "Input"],
Cell[21886, 669, 1067, 32, 53, "Output"],
Cell[22956, 703, 1006, 31, 53, "Output"],
Cell[23965, 736, 866, 28, 53, "Output"]
}, Open  ]],
Cell[24846, 767, 266, 5, 70, "Text"],
Cell[CellGroupData[{
Cell[25137, 776, 456, 16, 32, "Input"],
Cell[25596, 794, 2287, 67, 53, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27932, 867, 69, 0, 71, "Title"],
Cell[28004, 869, 478, 9, 94, "Text"],
Cell[28485, 880, 55, 0, 46, "Text"],
Cell[28543, 882, 375, 10, 121, "Input"],
Cell[28921, 894, 429, 11, 55, "Input"],
Cell[29353, 907, 482, 12, 55, "Input"],
Cell[29838, 921, 509, 12, 55, "Input"],
Cell[30350, 935, 659, 15, 55, "Input"],
Cell[31012, 952, 778, 19, 55, "Input"],
Cell[31793, 973, 57, 0, 46, "Text"],
Cell[31853, 975, 371, 10, 121, "Input"],
Cell[32227, 987, 156, 4, 32, "Input"],
Cell[32386, 993, 58, 0, 46, "Text"],
Cell[32447, 995, 378, 10, 121, "Input"],
Cell[32828, 1007, 156, 4, 32, "Input"],
Cell[32987, 1013, 65, 0, 46, "Text"],
Cell[33055, 1015, 91, 1, 32, "Input"],
Cell[33149, 1018, 68, 1, 32, "Input"],
Cell[33220, 1021, 70, 0, 46, "Text"],
Cell[33293, 1023, 78, 1, 32, "Input"]
}, Open  ]]
}
]
*)

